import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;

import net.kldp.logviewer.db.LogViewerDB;


public class LogTest {
	public static void main(String[] args) {
		
		String selGroup = "SELECT * FROM log_detail WHERE group_seq = ? AND status_yn = '00'";
		Connection conn = null;
		PreparedStatement stmtGrp = null;
	    ResultSet rsetGrp = null;
	
	    try {
	        conn = LogViewerDB.getInstance().getConnection();
	        stmtGrp = conn.prepareStatement(selGroup);
	        stmtGrp.setString(1, "1");
	        
	        rsetGrp = stmtGrp.executeQuery();	        
	        
	        while(rsetGrp.next()) {
	        	String name = rsetGrp.getString("NAME");
	        	String path = rsetGrp.getString("PATH");
	        	long delaySecond = rsetGrp.getBigDecimal("DELAY_SECOND").longValue();

	        	// default ׷쿡 شϴ detail  Ѵ.
	        	new MakeLogFile(path).start();
	        }
	        
	    } catch(SQLException e) {
	        e.printStackTrace();
	    } finally {
	        try { rsetGrp.close(); } catch(Exception e) { }
	        try { stmtGrp.close(); } catch(Exception e) { }
	        try { conn.close(); } catch(Exception e) { }
	    }
	}
}

class MakeLogFile extends Thread {	
	private String fileName= "";
	
	public MakeLogFile(String name) {
		fileName = name;
	}
	
	public void run() {
		
		while(true) {
			try {
				System.out.println(fileName);
				FileWriter f = new FileWriter(fileName, true);
				
				Properties prop = System.getProperties();
				Enumeration enums = prop.elements();
				
				while(enums.hasMoreElements()) {
					String objStr = (String)enums.nextElement();
					
					f.write(objStr + "\r\n");
				}
				
//				System.out.println("[ID]" + Thread.currentThread().getId() + "[name]" + Thread.currentThread().getName()  + "[" + fileName + "]    ֳ..." +  System.currentTimeMillis());
				
				f.flush();
				f.close();					
			} catch(IOException e) {
				e.printStackTrace();
			}
			
			// 2 ̳  Ѵ.
			try {
				Thread.sleep(new Random().nextInt(10000));
			} catch(Exception e) {}			
		}
	}
}
